//
//  $Id: WXKBookmarkWindowController_Metadata.m 108 2009-06-24 14:54:10Z fujidana $
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "WXKBookmarkWindowController.h"


@implementation WXKBookmarkWindowController (Metadata)

- (void)managedObjectContextDidSave:(NSNotification *)notification
{
	NSDictionary *userInfo = [notification userInfo];
	
	NSSet           *insertedObjectsSet = [userInfo objectForKey:NSInsertedObjectsKey];
	NSSet           *updatedObjectsSet  = [userInfo objectForKey:NSUpdatedObjectsKey];
	NSSet           *deletedObjectsSet  = [userInfo objectForKey:NSDeletedObjectsKey];
	NSEnumerator    *enumerator;
	NSManagedObject *object;
	
	NSEntityDescription *bookmarkEntity    = [NSEntityDescription entityForName:@"Bookmark" inManagedObjectContext:[self managedObjectContext]];
	NSString            *metadataDirectory = [[self class] metadataDirectory];
	NSFileManager       *fileManager       = [NSFileManager defaultManager];
	NSArray             *keys              = [NSArray arrayWithObjects:@"title", @"url", nil];
	
	enumerator = [deletedObjectsSet objectEnumerator];
	while (object = [enumerator nextObject])
	{
		if ([object entity] == bookmarkEntity)
		{
			NSString *absoluteString    = [[[object objectID] URIRepresentation] absoluteString];
			NSString *lastPathComponent = [absoluteString lastPathComponent];
			if (lastPathComponent == nil) continue;
			
			NSString *filename = [metadataDirectory stringByAppendingPathComponent:[lastPathComponent stringByAppendingPathExtension:@"kyoponbookmark"]];
			
			if ([fileManager removeFileAtPath:filename handler:nil] == NO)
			{
				NSLog(@"remove failed: %@", object);
			}
		}
	}
	
	enumerator = [insertedObjectsSet objectEnumerator];
	while (object = [enumerator nextObject])
	{
		if ([object entity] == bookmarkEntity)
		{
			NSString *absoluteString    = [[[object objectID] URIRepresentation] absoluteString];
			NSString *lastPathComponent = [absoluteString lastPathComponent];
			if (lastPathComponent == nil) continue;
			
			NSString     *filename   = [lastPathComponent stringByAppendingPathExtension:@"kyoponbookmark"];
			NSString     *path       = [metadataDirectory stringByAppendingPathComponent:filename];
			NSDictionary *dictionary = [object dictionaryWithValuesForKeys:keys];
			if ([dictionary writeToFile:path atomically:YES] == NO)
			{
				NSLog(@"insert failed: %@", object);
			}
		}
	}
	
	enumerator = [updatedObjectsSet objectEnumerator];
	while (object = [enumerator nextObject])
	{
		if ([object entity] == bookmarkEntity)
		{
			NSString *absoluteString    = [[[object objectID] URIRepresentation] absoluteString];
			NSString *lastPathComponent = [absoluteString lastPathComponent];
			if (lastPathComponent == nil) continue;
			
			NSString     *filename   = [lastPathComponent stringByAppendingPathExtension:@"kyoponbookmark"];
			NSString     *path       = [metadataDirectory stringByAppendingPathComponent:filename];
			NSDictionary *dictionary = [object dictionaryWithValuesForKeys:keys];
			if ([dictionary writeToFile:path atomically:YES] == NO)
			{
				NSLog(@"update failed: %@", object);
			}
		}
	}
}

@end
